//*************+***************+***************+***************+***************+
//
//	SEKONIC
//	Device control header
//
//	FileName	: SkDvSrBaseApi.h
//	CPU			: x86
//	Compiler	: Microsoft Visual C++ 2010
//
//*************+***************+***************+***************+***************+
//	2011.10.27	for SR-3500/6000/6500/1800/2300/5500
//*************+***************+***************+***************+***************+
#ifndef	INCLUDE_SKDVSRBASEAPI_HEADER			// Multi include of a header is prevented.
#define	INCLUDE_SKDVSRBASEAPI_HEADER

#pragma once


#include "SkDvSrSeriesPrm.h"


//*************+***************+***************+***************+***************+
#ifdef __cplusplus
extern "C" {
#endif


//*************+***************+***************+***************+***************+
//
//	Getting Module info
//
//		Getting Name and Version of this library.
//
//	Parameters
//		pModuleInfo			Appointing the address of Structure to fold info.
//
//	Return value
//		None
//
//	Remarks
//		Not necessary to Open operation in advance, in case library has been loaded.
//		After excution, Name and Version of this module are folded into Argument "pModuleInfo".
//
//*************+***************+***************+***************+***************+
void	WINAPI	SkDv_GetModuleInfo(SK_DV_MODULE_INFO* pModuleInfo);


//*************+***************+***************+***************+***************+
//
//	SkDv_OpenSingle
//
//		Searching OMR Device connected to USB, and enabling communication.
//
//	Parameters
//		phSkDevice		Appointing the pointer to receive opened Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		By executing this Function, the preparations to secure operating memory and to communicate 
//		with Device are done, And then it enables various operations. 
//		Needed to execute this procedure in advance of operation. 
//		In case more than one unit of OMR are connected by internal management, first OMR Device will be connected.
//
//		In case of success, Device controlling handle is folded into "phSkDevice". 
//		If failed, NULL(0) is folded into "phSkDevice".
//		By using this handle, various operations of this Middleware are done.
//		Attn: In case of using this Function, it is not able to use Old API library.
//
//		"SkDv_OpenSingle" can correspond with only one unit, and return Error in case there is another operating Device. 
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_OpenSingle(SkDvHandle *phSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_OpenWithOmrapi
//
//		Searching OMR Device USB connected, and enables communication.
//		Controlling by Old API library is to be available.
//
//	Parameters
//		phSkDevice		Appointing the pointer to receive opened Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		By executing Old API library's "OMR_OpenDeviceUSB", Old API Function is to be available. 
//		Except for this point, same as "SkDv_OpenSingle".
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_OpenWithOmrapi(SkDvHandle *phSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_Close
//
//		Executing when finishing all the operation, and releases various memories.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Attn: Use the controlling handle received by opening operation.
//		Attn 2: In case of re-opening the same Device, controlling handle will change.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_Close(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqInit
//
//		Resetting Software toward Device, and gets various operating condition.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Resetting Software is also executed.
//		Also, Device operating condition, Image data and internal operating data are all to be initialized.
//		In addition, each operating condition and to obtain device information from the device.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqInit(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_GetInfo
//
//		Getting Version info. of Device controlling and info. of function possessed.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pDvInfo			Appointing the address of Structure to fold Device info.
//						Description of Structure can be referred at "SK_DV_SR3500_INFO".
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		In case of Device info. has not been got, the Device info. 
//		Is to be folded into "pDvInfo" by communication to Device.
//		If you would like to communicate with Device in advance, 
//		please call Function "SkDv_ReqInit" or "SkDv_ReqGetInfo".
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_GetInfo(SkDvHandle hSkDevice, SK_DV_SR3500_INFO* pDvInfo);


//*************+***************+***************+***************+***************+
//
//	SkDv_GetMode
//
//		Getting Operating mode folded in Library.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pDvMode			Appointing the address of Structure to fold Operation mode. 
//						Description of Structure can be referred at "SK_DV_SR3500_MODE"
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Operating mode to get is saved in this library.
//		Operation mode saved by this library is folded into Parameter "pDvMode".
//		Communication with Device is not done.
//		If you would like to get description settled in Device right after starting, 
//		please call Function "SkDv_ReqInit" or "SkDv_ReqGetMode".

//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_GetMode(SkDvHandle hSkDevice, SK_DV_SR3500_MODE* pDvMode);


//*************+***************+***************+***************+***************+
//
//	SkDv_SetMode
//
//		Settling Operation mode in Library
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pDvMode			Appointing the address of Structure to fold Operation mode. 
//						Description of Structure can be referred at "SK_DV_SR3500_MODE"
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		If getting Device info. has not been done, you can communicate 
//		with Device and fold the Device info. into library. 
//		Operation mode appointed at Parameter "pDvMode" is checked as referring to Device info's description,
//		and if the value has any problems, Error is returned.
//		If there is no error, Operation mode is folded into Library.
//		Setting description of Operation mode can be settle into Device 
//		by executing "Demand for Reading" or Function "SkDv_ReqSetMode" via communication.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_SetMode(SkDvHandle hSkDevice, SK_DV_SR3500_MODE* pDvMode);


//*************+***************+***************+***************+***************+
//
//	SkDv_GetMarkConf
//
//		Getting Operating condition for Mark reading folded in Library.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pDvMarkConf		Appointing the address of Structure to fold Operating condition for Mark reading.
//						Structure description can be referred at "SK_DV_SR3500MARK_CONF".
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Operating condition for Mark reading to get is saved in this Library. 
//		Operating condition for Mark reading is folded in Parameter "pDvMarkConf".
//		Communication with Device is not done.
//		If you would like to get description settled in Device right after starting,
//		please call Function "SkDv_ReqInit" or "SkDv_ReqGetMarkConf".
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_GetMarkConf(SkDvHandle hSkDevice, SK_DV_SR3500MARK_CONF* pDvMarkConf);


//*************+***************+***************+***************+***************+
//
//	SkDv_SetMarkConf
//
//		Settling Operating condition for Mark reading into Library.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pDvMarkConf		Appointing the address of Structure to fold Operating condition for Mark reading
//						Structure description can be referred at "SK_DV_SR3500MARK_CONF".
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		If getting Device info has not been done, 
//		you can communicate with Device and fold the Device info into library. 
//		Operation mode for Mark reading appointed at Parameter "pDvMarkConf" 
//		is checked as referring to Device info's description, 
//		and if the value has any problems, Error is returned.
//		If there is no error, Operation mode is folded into Library.
//		Setting description of Operation mode for Mark reading can be settle into Device 
//		by executing "Demand for Reading" or Function "SkDv_ReqMarkConf" via communication.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_SetMarkConf(SkDvHandle hSkDevice, SK_DV_SR3500MARK_CONF* pDvMarkConf);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqGetStatus
//
//		Getting Device status info. by communication.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pStatusChar		Appointing the address of Structure to fold Device status code info.
//						Structure description can be referred at "SK_DV_SR3500_STATUS_CHAR".
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Using Demand command for Error description info "DE" to get Status info. and Error description info.
//		Device error is returned also in Return value.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqGetStatus(SkDvHandle hSkDevice, SK_DV_SR3500_STATUS_CHAR* pStatusChar);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqGetSensor
//
//		Getting Device sensor state by communication.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		pdwSensor		Appointing the address of Variable to fold Sensor state.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Using Demand command for Sensor state info "DS", to get Status info. and Error description info.
//		Folding the state of Sensor assigned to bit into Parameter "pdwSensor".
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqGetSensor(SkDvHandle hSkDevice, DWORD* pdwSensor);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqBuzzer
//
//		Sound the buzzer by communication.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Use the command "BZ", sound the buzzer.
//		It does not sound if the buzzer is disabled.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqBuzzer(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqFeedMarkSheet
//
//		Reading Mark sheet.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Reading Mark sheets by Command "SF".
//		Not to read Image data.
//		If the communication for getting Image/setting Condition has not been done, 
//		the communication will be done before Reading.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqFeedMarkSheet(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqMoveHopper
//
//		Ejected in the form of the device.
//
//	
//		hSkDevice		Appointing Device controlling handle.
//		iUpDown			Specify the Up / Down.
//
//	߂l
//		Status code (SkDvStatus)
//
//	ڍ
//		The command "HU" hopper operation, operation of raising and lowering of the hopper.
//		To manually operated, SR-1800 is the hopper does not work even if this function is executed.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqMoveHopper(SkDvHandle hSkDevice, int iUpDown);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqEjectForm
//
//		Ejecting sheet from Device.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		iDirection		Appointing the operation of ejection.
//						Setting value can be refered at "Description"
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Ejecting the sheet by command of Ejection "ER".
//		If the stacker unit is not connected, switching of Main stacker and Select stacker is not done.
//		In SR-3500HYBRID, Image reading is accompanied with Ejecting operation.
//		Hence, this Function cannot execute Ejecting operation.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqEjectForm(SkDvHandle hSkDevice, int iDirection);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqClearError
//
//		Clearing the Error happening in Device.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		By Error clearing command "CE", clearing the Error happening in Device.
//		However, in case of Non-clearable Error, it would return another massage of Error.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqClearError(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqGetMarks
//
//		Getting Mark data by communication.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//		iFace			Select  front side or back side
//
//		pMarkInfo		Appointing the address of Structure to fold Mark info.
//						The content of Structure can be referred at "SK_DV_MARK_INFO"
//
//		pMarks			Appointing the address of buffer to fold Mark data.
//						Mark density is folded per 1 byte in the value of 0 to 16.
//						In case you appointed "NULL", Mark data cannot be folded.
//
//		piBufSize		Appointing the byte size of buffer to fold Mark data.
//						Folding data into the buffer appointed in pMark up to appointed size.
//						After execution, the buffer size needed will be folded.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Using Demand code for Mark density data "MD", to get Mark data.
//		Appointing the address of Mark info Structure secured into Parameter "pMarkInfo"
//		Appointing the first address of buffer securing memories for unit number of Mark data, 
//		and the byte size of the buffer into Parameter "piBufSize" to call this API Function.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqGetMarks(SkDvHandle hSkDevice, 
	int iFace, SK_DV_MARK_INFO *pMarkInfo,
	char* pMarks, int* piBufSize);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqGetInfo
//
//		Communicating to get Device info.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Communicating to get Device info. and saves it into Library.
//		Using commands is as following.
//		- Demand command for Device info "DI"
//		- Demand command for Model name "MN"
//		- Demand command for Firmware version "FV"
//		- Other - Closed command
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqGetInfo(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqGetMode
//
//		Communicating to get Operation mode.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Communicating to get Operation mode, and saves it into Library.
//		Using commands is as following.
//		- Setting command for Warning error "WE"
//		- Setting command for Panel operation "PO"
//		- Setting command for Buzzer "BZ"
//		- Setting command for Energy saving "ES"
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqGetMode(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqSetMode
//
//		Communicating to set Operating mode.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Settling the Operation mode in Library into Device.
//		Using command is as same as "SkDv_ReqGetMode" Function.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqSetMode(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqGetMarkConf
//
//		Communicating to get Mark condition
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Communicating to get Mark condition, and to save it into Library
//		Using command is as following.
//		- Setting command for Reading column "NC"
//		- Setting command for the Reading method "RM"
//		- Setting command for Back side reading "BR"
//		- Setting command for Sheet thickness "FT"
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqGetMarkConf(SkDvHandle hSkDevice);


//*************+***************+***************+***************+***************+
//
//	SkDv_ReqSetMarkConf
//
//		Communicating to set Mark condition.
//
//	Parameters
//		hSkDevice		Appointing Device controlling handle.
//
//	Return value
//		Status code (SkDvStatus)
//
//	Remarks
//		Settling the Mark condition in Library into Device.
//		Using command is as same as "SkDv_ReqGetMarkConf" Function.
//
//*************+***************+***************+***************+***************+
SkDvStatus	WINAPI	SkDv_ReqSetMarkConf(SkDvHandle hSkDevice);


#ifdef __cplusplus
}
#endif

#endif											// Multi include of a header is prevented.

